package nemosofts.voxradio.utils;

import android.content.Context;
import android.content.SharedPreferences;

import nemosofts.voxradio.callback.Callback;

public class SharedPref {

    private final EncryptData encryptData;
    private final SharedPreferences sharedPreferences;
    private final SharedPreferences.Editor editor;

    private static final String TAG_FIRST_OPEN = "firstopen", TAG_IS_LOGGED = "islogged", TAG_UID = "uid", TAG_USERNAME = "name",
            TAG_EMAIL = "email", TAG_MOBILE = "mobile", TAG_GENDER = "gender", TAG_REMEMBER = "rem" ,
            TAG_PASSWORD = "pass", SHARED_PREF_AUTOLOGIN = "autologin", TAG_LOGIN_TYPE = "loginType",
            TAG_AUTH_ID = "auth_id", TAG_IMAGES = "profile";

    public SharedPref(Context ctx) {
        encryptData = new EncryptData(ctx);
        sharedPreferences = ctx.getSharedPreferences("setting_app", Context.MODE_PRIVATE);
        editor = sharedPreferences.edit();
    }

    public void setIsFirst(Boolean flag) {
        editor.putBoolean(TAG_FIRST_OPEN, flag);
        editor.apply();
    }

    public Boolean getIsFirst() {
        return sharedPreferences.getBoolean(TAG_FIRST_OPEN, true);
    }

    public void setIsLogged(Boolean isLogged) {
        editor.putBoolean(TAG_IS_LOGGED, isLogged);
        editor.apply();
    }

    public boolean isLogged() {
        return sharedPreferences.getBoolean(TAG_IS_LOGGED, false);
    }

    public void setLoginDetails(String id, String name, String mobile, String email, String gender, String profilePic, String authID, Boolean isRemember, String password, String loginType) {
        editor.putBoolean(TAG_REMEMBER, isRemember);
        editor.putString(TAG_UID, encryptData.encrypt(id));
        editor.putString(TAG_USERNAME, encryptData.encrypt(name));
        editor.putString(TAG_MOBILE, encryptData.encrypt(mobile));
        editor.putString(TAG_EMAIL, encryptData.encrypt(email));
        editor.putString(TAG_GENDER, encryptData.encrypt(gender));
        editor.putString(TAG_PASSWORD, encryptData.encrypt(password));
        editor.putString(TAG_LOGIN_TYPE, encryptData.encrypt(loginType));
        editor.putString(TAG_AUTH_ID, encryptData.encrypt(authID));
        if (profilePic != null) {
            editor.putString(TAG_IMAGES, encryptData.encrypt(profilePic.replace(" ", "%20")));
        }
        editor.apply();
    }

    public void setRemember(Boolean isRemember) {
        editor.putBoolean(TAG_REMEMBER, isRemember);
        editor.putString(TAG_PASSWORD, "");
        editor.apply();
    }

    public String getUserId() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_UID, ""));
    }

    public void setUserName(String userName) {
        editor.putString(TAG_USERNAME, encryptData.encrypt(userName));
        editor.apply();
    }

    public String getUserName() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_USERNAME, ""));
    }

    public void setEmail(String email) {
        editor.putString(TAG_EMAIL, encryptData.encrypt(email));
        editor.apply();
    }

    public String getEmail() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_EMAIL,""));
    }

    public void setUserMobile(String mobile) {
        editor.putString(TAG_MOBILE, encryptData.encrypt(mobile));
        editor.apply();
    }

    public String getUserMobile() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_MOBILE, ""));
    }

    public String getPassword() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_PASSWORD,""));
    }

    public Boolean getIsAutoLogin() { return sharedPreferences.getBoolean(SHARED_PREF_AUTOLOGIN, false); }

    public void setIsAutoLogin(Boolean isAutoLogin) {
        editor.putBoolean(SHARED_PREF_AUTOLOGIN, isAutoLogin);
        editor.apply();
    }

    public Boolean getIsRemember() {
        return sharedPreferences.getBoolean(TAG_REMEMBER, false);
    }


    public String getLoginType() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_LOGIN_TYPE,""));
    }

    public String getAuthID() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_AUTH_ID,""));
    }
    public String getProfileImages() {
        return encryptData.decrypt(sharedPreferences.getString(TAG_IMAGES,""));
    }
    public void setProfileImages(String profilePic) {
        if (profilePic != null) {
            editor.putString(TAG_IMAGES, encryptData.encrypt(profilePic.replace(" ", "%20")));
            editor.apply();
        }
    }


    public void getThemeDetails() {
        Callback.nowPlayingScreen = getNowPlayingScreen().ordinal();
    }

    public Boolean getIsNotification() {
        return sharedPreferences.getBoolean("noti", true);
    }

    public void setIsNotification(Boolean isNotification) {
        editor.putBoolean("noti", isNotification);
        editor.apply();
    }

    public int getTextSize() {
        return sharedPreferences.getInt("text_size", 2);
    }

    public void setTextSize(int state) {
        editor.putInt("text_size", state);
        editor.apply();
    }

    // Drive mode
    public Boolean isDriveColor() { return sharedPreferences.getBoolean("switch_color_drive", false); }
    public void setDriveColor(Boolean state) {
        editor.putBoolean("switch_color_drive", state);
        editor.apply();
    }

    public Boolean isDriveSnowFall() { return sharedPreferences.getBoolean("drive_snow_fall", false); }
    public void setDriveSnowFall(Boolean state) {
        editor.putBoolean("drive_snow_fall", state);
        editor.apply();
    }

    public Boolean isDriveKeepScreen() { return sharedPreferences.getBoolean("drive_screen", false); }
    public void setDriveKeepScreen(Boolean state) {
        editor.putBoolean("drive_screen", state);
        editor.apply();
    }

    public int getBlurAmountDrive() {
        return sharedPreferences.getInt("blur_amount_drive", 5);
    }
    public void setBlurAmountDrive(int state) {
        editor.putInt("blur_amount_drive", state);
        editor.apply();
    }

    // Now Player
    public Boolean isVolume() { return sharedPreferences.getBoolean("switch_volume", true); }
    public void setVolume(Boolean state) {
        editor.putBoolean("switch_volume", state);
        editor.apply();
    }

    public Boolean isSnowFall() { return sharedPreferences.getBoolean("switch_snow_fall", false); }
    public void setSnowFall(Boolean state) {
        editor.putBoolean("switch_snow_fall", state);
        editor.apply();
    }

    public int getBlurAmount() {
        return sharedPreferences.getInt("blur_amount", 50);
    }
    public void setBlurAmount(int state) {
        editor.putInt("blur_amount", state);
        editor.apply();
    }

    public final NowPlayingScreen getNowPlayingScreen() {
        int id = sharedPreferences.getInt("playing_screen_id", 0);
        for (NowPlayingScreen nowPlayingScreen : NowPlayingScreen.values()) {
            if (nowPlayingScreen.id == id) {
                return nowPlayingScreen;
            }
        }
        return NowPlayingScreen.NORMAL;
    }

    public void setNowPlayingScreen(NowPlayingScreen nowPlayingScreen) {
        if (nowPlayingScreen != null){
            editor.putInt("playing_screen_id", nowPlayingScreen.id);
            editor.apply();
        }
    }

    public void setCheckSleepTime() {
        if (getSleepTime() <= System.currentTimeMillis()) {
            setSleepTime(false, 0, 0);
        }
    }
    public void setSleepTime(Boolean isTimerOn, long sleepTime, int id) {
        editor.putBoolean("isTimerOn", isTimerOn);
        editor.putLong("sleepTime", sleepTime);
        editor.putInt("sleepTimeID", id);
        editor.apply();
    }
    public Boolean getIsSleepTimeOn() {
        return sharedPreferences.getBoolean("isTimerOn", false);
    }
    public long getSleepTime() {
        return sharedPreferences.getLong("sleepTime", 0);
    }
    public int getSleepID() {
        return sharedPreferences.getInt("sleepTimeID", 0);
    }
}